/*
 * mpu6000.c
 *
 *  Created on: Mar 31, 2015
 *      Author: Jordan
 */

#include "spi.h"
#include "mpu6000.h"
#include "config.h"

// SPI transfer settings
spiDAT1_t spi_mpu6000 = {TRUE, FALSE, SPI_FMT_0, SPI_CS_5};

void mpu6000_init(){
	// Reset sensor
	uint16 tx[2] = {0x6B,0x80};
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);
	delay_ms(10);

	// Disable I2C
	tx[0] = 0x6A; tx[1] = 0x10;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Disable interrupts
	tx[0] = 0x38; tx[1] = 0x0;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Set clock source to gyro-z PLL
	tx[0] = 0x6B; tx[1] = 0x03;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Set sample rate (1kHz)
	tx[0] = 0x19; tx[1] = 0x0;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Set sensor rate & LPF (8.5ms delay, 20 Hz bandwidth)
	tx[0] = 0x1A; tx[1] = 0x4;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Set accelerometer scale
	tx[0] = 0x1C; tx[1] = ACC_4G;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);

	// Set gyro scale
	tx[0] = 0x1B; tx[1] = GYRO_1000DPS;
	spiTransmitData(spiREG1, &spi_mpu6000, 2, tx);
	delay_ms(25);
}

float32 mpu6000_get_acc(char axis){
	// Select register
	uint16 reg;
	switch(axis){
		case 'x': reg = 0xBB; break;
		case 'y': reg = 0xBD; break;
		case 'z': reg = 0xBF; break;
	}

	// Get acc value
	uint16 tx[3] = {reg,0,0};
	uint16 rx[3];
	spiTransmitAndReceiveData(spiREG1, &spi_mpu6000, 3, tx, rx);

	// Format acc value
	float32 acc_value = (float32) ((sint16)(rx[1]<<8 | rx[2]))/ACC_4G_DIV;
	switch(axis){
		case 'x': acc_value = -acc_value; break;
		case 'y': acc_value = acc_value; break;
		case 'z': acc_value = acc_value; break;
	}
	return acc_value;
}

float32 mpu6000_get_gyro(char axis){
	// Select register
	uint16 reg;
	switch(axis){
		case 'x': reg = 0xC3; break;
		case 'y': reg = 0xC5; break;
		case 'z': reg = 0xC7; break;
	}

	// Get gyro value
	uint16 tx[3] = {reg,0,0};
	uint16 rx[3];
	spiTransmitAndReceiveData(spiREG1, &spi_mpu6000, 3, tx, rx);

	// Format gyro value
	float32 gyro_value = (float32) ((sint16)(rx[1]<<8 | rx[2]))/GYRO_1000DPS_DIV;
	switch(axis){
		case 'x': gyro_value = gyro_value; break;
		case 'y': gyro_value = -gyro_value; break;
		case 'z': gyro_value = -gyro_value; break;
	}
	return gyro_value;
}

float32 mpu6000_get_temp(){
	// Get temperature value
	uint16 tx[3] = {0xC1,0,0};
	uint16 rx[3] = {0,0,0};
	spiTransmitAndReceiveData(spiREG1, &spi_mpu6000, 3, tx, rx);

	// Format temperature value
	return (float32) ((sint16)(rx[1]<<8 | rx[2]))/340 + 36.53;
}
